#include"Switcher.h"
#include<OS.h>

long wsCount;
float dock;

SwitcherView :: SwitcherView(BRect r) 
	: BView(r,"Switcher",B_FOLLOW_ALL,B_WILL_DRAW | B_PULSE_NEEDED)
{
	BMenuItem 	*item;
	BMessage	*message;

	menu = new BPopUpMenu("",FALSE,FALSE);

	item=new BMenuItem("Quit", new BMessage(B_QUIT_REQUESTED));
	item->SetTarget(be_app);
	menu->AddItem(item);
	
	menu->AddSeparatorItem();
		
	message=new BMessage(ssChangeMode);
	message->AddLong("mode",B_8_BIT_640x480);
	item=new BMenuItem("640x480-8bit",message);
	item->SetTarget(be_app);
	menu->AddItem(item);
	
	message=new BMessage(ssChangeMode);
	message->AddLong("mode",B_8_BIT_800x600);
	item=new BMenuItem("800x600-8bit",message);
	item->SetTarget(be_app);
	menu->AddItem(item);
	
	message=new BMessage(ssChangeMode);
	message->AddLong("mode",B_8_BIT_1024x768);
	item=new BMenuItem("1024x768-8bit",message);
	item->SetTarget(be_app);
	menu->AddItem(item);
	
	message=new BMessage(ssChangeMode);
	message->AddLong("mode",B_8_BIT_1152x900);
	item=new BMenuItem("1152x900-8bit",message);
	item->SetTarget(be_app);
	menu->AddItem(item);

	SetViewColor(0,0,0,0);

	labelOffsets = new float[wsCount];
}

SwitcherView :: ~SwitcherView()
{
	delete[] labelOffsets;
}

void SwitcherView :: MouseDown(BPoint p)
{
    ulong buttons;
	screen_info sInfo;

    buttons = Window()->CurrentMessage()->FindLong("buttons"); 

    if(buttons==B_PRIMARY_MOUSE_BUTTON)
	{
		if (p.x <= 180.0)
			currentWorkspace=((int)(p.x)/20);
		else {
			float valLow = 180.0;
			float valHigh = valLow;
			// 0 instead of 1 due to count_workspaces starting at 0 for 1....
			for(int n=0; n <= (wsCount-9); n++) {
				valHigh += 20.0 + labelOffsets[n-1];
				if (p.x > valLow && p.x <= valHigh) {
					currentWorkspace = n + 9;
					break;
				}
				else
					valLow = valHigh;
			}
		}			 
		activate_workspace(currentWorkspace);
		Invalidate();
	}
	else if(buttons==B_SECONDARY_MOUSE_BUTTON)
	{
		menu->Go(ConvertToScreen(p),TRUE);	
	}
}

void SwitcherView :: Pulse()
{

	int cw=current_workspace();
	if(currentWorkspace!=cw) 
	{
		currentWorkspace=cw;
		Invalidate();
	}
	
	long wsDiff = count_workspaces() - wsCount;
	if (wsDiff != 0) {
		wsCount += wsDiff;
		delete[] labelOffsets;	
		labelOffsets = new float[wsCount];
		Invalidate();
	}
	
	float newDock;
	get_dock_width(&newDock);
	if (newDock != dock) {
		Window()->MoveTo(newDock, 0.0);
		dock = newDock;
	}
}

void SwitcherView :: Draw(BRect updateRect)
{
	#pragma unused(updateRect)

	float pos=10.0;
	SetHighColor(0,255,0,0);
	for (int n=1; n <= wsCount; n++)
	{
		char * label = new char[3];
		if(n==currentWorkspace+1) SetHighColor(255,0,0);
		sprintf(label, "%d", n);
		DrawString(label,*(new BPoint(pos,11)));			
		if(n==currentWorkspace+1) SetHighColor(0,255,0);
		if (strlen(label) == 1)
			pos+=20;
		else {
			labelOffsets[n-10] = StringWidth(&label[1]);
			pos += (20.0 + labelOffsets[n-10]);
		}
		delete[] label;
	}
	Window()->ResizeTo(pos, 15);
}


// SWITCHER WINDOW

SwitcherWindow::SwitcherWindow(BRect r)
	 : BWindow(r, "Switcher", B_BORDERED_WINDOW, B_NOT_RESIZABLE | B_WILL_ACCEPT_FIRST_CLICK,B_ALL_WORKSPACES)
{
	SetPulseRate(50000.0);
	SwitcherView *view;
	r.OffsetTo(BPoint(0, 0));
	view=new SwitcherView(r);
	AddChild(view);
	Show();
}


bool SwitcherWindow::QuitRequested()
{
	be_app->PostMessage(B_QUIT_REQUESTED);
	return TRUE;
}


// SWITCHER APP

SwitcherApp::SwitcherApp(ulong sig) : BApplication(sig)
{
	BRect			r;
	SwitcherWindow	*theWindow;
	get_dock_width(&dock);
	wsCount = count_workspaces();
	long winRight = dock + 10 + (wsCount * 20);
	r.Set(dock,0,winRight,15);	
	theWindow = new SwitcherWindow(r);		
}

void SwitcherApp :: MessageReceived(BMessage *message)
{
	if(message->what==ssChangeMode)
	{
		set_screen_space(current_workspace(),message->FindLong("mode"),TRUE);
	}
	else inherited::MessageReceived(message);
}


void main()
{
	SwitcherApp* app = new SwitcherApp('SPSW');
	app->Run();
		
	delete(app);	
}